/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ElementsIndexingUtils;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IElementEntriesFilter;
import com.aptana.editor.php.internal.indexer.NamespacePHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org2.eclipse.php.core.compiler.PHPFlags;

public class ContentAssistFilters {
    public static Set<IElementEntry> filterByModule(Collection<IElementEntry> input, IModule module, IElementsIndex index) {
        IElementEntriesFilter filter = ElementsIndexingUtils.createIncludeFilter(module, index);
        if (filter == null) {
            LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
            result.addAll(input);
            return result;
        }
        return filter.filter(input);
    }

    public static Set<IElementEntry> filterStaticEntries(Set<IElementEntry> entries) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : entries) {
            AbstractPHPEntryValue val;
            int modifiers;
            if (entry.getCategory() == 4) {
                result.add(entry);
                continue;
            }
            if (entry.getCategory() != 3 && entry.getCategory() != 2 || !(entry.getValue() instanceof AbstractPHPEntryValue) || !PHPFlags.isStatic((int)(modifiers = (val = (AbstractPHPEntryValue)entry.getValue()).getModifiers()))) continue;
            result.add(entry);
        }
        return result;
    }

    public static Set<IElementEntry> filterNonStaticVariables(Set<IElementEntry> entries) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : entries) {
            AbstractPHPEntryValue val;
            int modifiers;
            if (entry.getCategory() != 3 && entry.getCategory() != 2 || !(entry.getValue() instanceof AbstractPHPEntryValue) || PHPFlags.isStatic((int)(modifiers = (val = (AbstractPHPEntryValue)entry.getValue()).getModifiers())) && entry.getCategory() == 3) continue;
            result.add(entry);
        }
        return result;
    }

    public static List<IElementEntry> filterFieldsAndMembers(List<IElementEntry> entries) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IElementEntry entry : entries) {
            if (entry.getValue() instanceof VariablePHPEntryValue) {
                VariablePHPEntryValue value = (VariablePHPEntryValue)entry.getValue();
                if (value.isField() && entry.getCategory() != 4) continue;
                result.add(entry);
                continue;
            }
            if (entry.getValue() instanceof FunctionPHPEntryValue) {
                if (((FunctionPHPEntryValue)entry.getValue()).isMethod()) continue;
                result.add(entry);
                continue;
            }
            if (entry.getValue() instanceof ClassPHPEntryValue) {
                result.add(entry);
                continue;
            }
            if (!(entry.getValue() instanceof NamespacePHPEntryValue)) continue;
            result.add(entry);
        }
        return result;
    }

    public static List<IElementEntry> filterGlobalVariables(List<IElementEntry> entries, Set<String> globalImports) {
        if (globalImports == null) {
            return entries;
        }
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IElementEntry entry : entries) {
            VariablePHPEntryValue val;
            if (entry.getValue() instanceof VariablePHPEntryValue && !(val = (VariablePHPEntryValue)entry.getValue()).isField() && !val.isLocal() && !val.isParameter() && !globalImports.contains(ElementsIndexingUtils.getLastNameInPath(entry.getEntryPath()))) continue;
            result.add(entry);
        }
        return result;
    }

    public static Set<IElementEntry> filterAllButFunctions(Set<IElementEntry> entries, IElementsIndex index) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : entries) {
            Object value = entry.getValue();
            if (value instanceof FunctionPHPEntryValue) {
                result.add(entry);
            }
            if (!(value instanceof ClassPHPEntryValue)) continue;
            String entryPath = entry.getEntryPath();
            List<IElementEntry> entries2 = index.getEntries(2, String.valueOf(entryPath) + '/' + "__construct");
            for (IElementEntry e : entries2) {
                result.add(e);
            }
            if (!entries2.isEmpty()) continue;
            entries2 = index.getEntries(2, String.valueOf(entryPath) + '/' + entryPath);
            for (IElementEntry e : entries2) {
                result.add(e);
            }
        }
        return result;
    }

    public static Set<IElementEntry> filterAllButClasses(Set<IElementEntry> entries, IElementsIndex index) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : entries) {
            Object value = entry.getValue();
            if (!(value instanceof ClassPHPEntryValue)) continue;
            result.add(entry);
        }
        return result;
    }

    public static Set<IElementEntry> filterAllButVariablesAndClasses(Set<IElementEntry> entries, IElementsIndex index) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : entries) {
            Object value = entry.getValue();
            if (!(value instanceof VariablePHPEntryValue) && !(value instanceof ClassPHPEntryValue)) continue;
            result.add(entry);
        }
        return result;
    }
}

